﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;
using System.Xml;

namespace post
{
    class Program
    {
        static void Main(string[] args)
        {
            try
            {


                string strUrl = "http://kleber.datatoolscloud.net.au/KleberWebServiceSoap/DtKleberService.svc?WSDL";
                                
                string strRequest = @"<?xml version='1.0' encoding='utf-8'?>
            <soapenv:Envelope xmlns:soapenv='http://schemas.xmlsoap.org/soap/envelope/' xmlns:tem='http://tempuri.org/'> 
                <soapenv:Header/> 
                <soapenv:Body> 
                    <tem:ProcessXmlRequest>                         
                        <tem:DtXmlRequest> 
                            &lt;DtRequest Method='DataTools.Capture.Address.Predictive.AuPaf.SearchAddress' 
                                AddressLine='27 Hunter st' 
                                ResultLimit='5' 
                                RequestId='' 
                                RequestKey='' 
                                DepartmentCode='' /&gt; 
                        </tem:DtXmlRequest> 
                    </tem:ProcessXmlRequest> 
                </soapenv:Body> 
            </soapenv:Envelope>";

                // Create the Request object.
                HttpWebRequest req = (HttpWebRequest)WebRequest.Create(strUrl);
                req.Method = "POST";
                req.ContentType = "text/xml; charset=utf-8";
                req.Headers.Add("SOAPAction: \"http://tempuri.org/IDtKleberService/ProcessXmlRequest\"");

                req.ContentLength = strRequest.Length;

                // Send the request.
                StreamWriter swRequest = new StreamWriter(req.GetRequestStream(), System.Text.Encoding.ASCII);
                swRequest.Write(strRequest);
                swRequest.Close();

                // Receive the response.
                StreamReader srResponse = new StreamReader(req.GetResponse().GetResponseStream());
                string strResponse = srResponse.ReadToEnd();
                srResponse.Close();

                // Output the response.
                Console.WriteLine(strResponse);
                Console.ReadKey();
            }
            catch (WebException ex)
            {
                Console.WriteLine(ex);
                WebResponse errRsp = ex.Response;
                using (StreamReader rdr = new StreamReader(errRsp.GetResponseStream()))
                {
                    Console.WriteLine(rdr.ReadToEnd());
                    Console.ReadKey();
                }
            }
        }
    }
}